<?xml version="1.0"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" omit-xml-declaration="yes"
	doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
	indent="yes"/>
 <!-- Display Parameters -->
<xsl:param name="xsl_version">1</xsl:param>
<xsl:param name="min_user_level">-10</xsl:param>
<xsl:param name="min_user_table">5</xsl:param>
 <!-- Root template -->
 <xsl:template match="/NANOSWITCH">
   <HTML>
   <HEAD>
   <TITLE>
    Marinex 3D Feature Codes
   </TITLE>
   <link rel="stylesheet" type="text/css" href="NANOCONF.css" />
   </HEAD>
   <BODY  onload="go_decoding();">
<xsl:if test="string-length(/NANOSWITCH/@XSL) &gt; 0">
<xsl:if test="/NANOSWITCH/@XSL &gt; $xsl_version">
<h1 class="WarningHeading">Style sheet warning</h1>
<p class="WarningMessage">Style sheet version is too low so some information may be mising. Version <xsl:value-of select="/NANOSWITCH/@XSL"/> of the style sheet is needed</p>
</xsl:if>
</xsl:if>

        <xsl:apply-templates select="features"/><br></br>
  <HR></HR>
   </BODY>
  </HTML>
 </xsl:template>

 <xsl:template match="features">
<DIV name="decodeable" CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar" COLSPAN="7">Features</TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="30%">Name</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Type</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Number</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Mode</TD>
<TD CLASS="TableInfoTitle" WIDTH="15%">Right</TD>
<TD CLASS="TableInfoTitle" WIDTH="15%">Function</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Subcode</TD>
</TR>
     <xsl:apply-templates/>
</TABLE>
</DIV>
 </xsl:template>
 <xsl:template match="feature">
<TR>
<TD CLASS="TableInfoL" WIDTH="30%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="name"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="type"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="number"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="mode"/></TD>
<TD CLASS="TableInfoL" WIDTH="15%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="right"/></TD>
<TD CLASS="TableInfoL" WIDTH="15%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="function"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="subcode"/></TD>
</TR>
 </xsl:template>

</xsl:stylesheet>
